#
# Script designed to be tested from inside the CamiTK Python interpreter using PythonManager::runScript
# See TestPythonScript.cpp
# 
# The requirements (if any) must defined in the the QRC file
#
import camitk
import sys
import re

# get version from the debug information
debug_info = camitk.getDebugInfo()
pattern = 'Python version: ([0-9.]+)\\n'
matches = re.findall(pattern, debug_info)
version = matches[0]

# get version directly from python (major.minor.patch)
full_version = ".".join(map(str, sys.version_info[0:3]))
assert version == full_version, f"Python version should not differ {version} != {full_version}"

# get version directly from PythonManager (only major.minor)
main_version = ".".join(map(str, sys.version_info[0:2]))
python_manager_version = camitk.getPythonVersion()
assert python_manager_version == main_version,  f"Python version should not differ {python_manager_version} != {main_version}"