//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armapplicationinsights

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type APIKeyRequest.
func (a APIKeyRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "linkedReadProperties", a.LinkedReadProperties)
	populate(objectMap, "linkedWriteProperties", a.LinkedWriteProperties)
	populate(objectMap, "name", a.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIKeyRequest.
func (a *APIKeyRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "linkedReadProperties":
			err = unpopulate(val, "LinkedReadProperties", &a.LinkedReadProperties)
			delete(rawMsg, key)
		case "linkedWriteProperties":
			err = unpopulate(val, "LinkedWriteProperties", &a.LinkedWriteProperties)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Annotation.
func (a Annotation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "AnnotationName", a.AnnotationName)
	populate(objectMap, "Category", a.Category)
	populateDateTimeRFC3339(objectMap, "EventTime", a.EventTime)
	populate(objectMap, "Id", a.ID)
	populate(objectMap, "Properties", a.Properties)
	populate(objectMap, "RelatedAnnotation", a.RelatedAnnotation)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Annotation.
func (a *Annotation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "AnnotationName":
			err = unpopulate(val, "AnnotationName", &a.AnnotationName)
			delete(rawMsg, key)
		case "Category":
			err = unpopulate(val, "Category", &a.Category)
			delete(rawMsg, key)
		case "EventTime":
			err = unpopulateDateTimeRFC3339(val, "EventTime", &a.EventTime)
			delete(rawMsg, key)
		case "Id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "Properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "RelatedAnnotation":
			err = unpopulate(val, "RelatedAnnotation", &a.RelatedAnnotation)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AnnotationError.
func (a AnnotationError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", a.Code)
	populate(objectMap, "innererror", a.Innererror)
	populate(objectMap, "message", a.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AnnotationError.
func (a *AnnotationError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &a.Code)
			delete(rawMsg, key)
		case "innererror":
			err = unpopulate(val, "Innererror", &a.Innererror)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &a.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AnnotationsListResult.
func (a AnnotationsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AnnotationsListResult.
func (a *AnnotationsListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Component.
func (c Component) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", c.Etag)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "kind", c.Kind)
	populate(objectMap, "location", c.Location)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "tags", c.Tags)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Component.
func (c *Component) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &c.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &c.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &c.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &c.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComponentAPIKey.
func (c ComponentAPIKey) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "apiKey", c.APIKey)
	populate(objectMap, "createdDate", c.CreatedDate)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "linkedReadProperties", c.LinkedReadProperties)
	populate(objectMap, "linkedWriteProperties", c.LinkedWriteProperties)
	populate(objectMap, "name", c.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComponentAPIKey.
func (c *ComponentAPIKey) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "apiKey":
			err = unpopulate(val, "APIKey", &c.APIKey)
			delete(rawMsg, key)
		case "createdDate":
			err = unpopulate(val, "CreatedDate", &c.CreatedDate)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "linkedReadProperties":
			err = unpopulate(val, "LinkedReadProperties", &c.LinkedReadProperties)
			delete(rawMsg, key)
		case "linkedWriteProperties":
			err = unpopulate(val, "LinkedWriteProperties", &c.LinkedWriteProperties)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComponentAPIKeyListResult.
func (c ComponentAPIKeyListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComponentAPIKeyListResult.
func (c *ComponentAPIKeyListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComponentAnalyticsItem.
func (c ComponentAnalyticsItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "Content", c.Content)
	populate(objectMap, "Id", c.ID)
	populate(objectMap, "Name", c.Name)
	populate(objectMap, "Properties", c.Properties)
	populate(objectMap, "Scope", c.Scope)
	populate(objectMap, "TimeCreated", c.TimeCreated)
	populate(objectMap, "TimeModified", c.TimeModified)
	populate(objectMap, "Type", c.Type)
	populate(objectMap, "Version", c.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComponentAnalyticsItem.
func (c *ComponentAnalyticsItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "Content":
			err = unpopulate(val, "Content", &c.Content)
			delete(rawMsg, key)
		case "Id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "Name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "Properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "Scope":
			err = unpopulate(val, "Scope", &c.Scope)
			delete(rawMsg, key)
		case "TimeCreated":
			err = unpopulate(val, "TimeCreated", &c.TimeCreated)
			delete(rawMsg, key)
		case "TimeModified":
			err = unpopulate(val, "TimeModified", &c.TimeModified)
			delete(rawMsg, key)
		case "Type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		case "Version":
			err = unpopulate(val, "Version", &c.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComponentAnalyticsItemProperties.
func (c ComponentAnalyticsItemProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "functionAlias", c.FunctionAlias)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComponentAnalyticsItemProperties.
func (c *ComponentAnalyticsItemProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "functionAlias":
			err = unpopulate(val, "FunctionAlias", &c.FunctionAlias)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComponentAvailableFeatures.
func (c ComponentAvailableFeatures) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "Result", c.Result)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComponentAvailableFeatures.
func (c *ComponentAvailableFeatures) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "Result":
			err = unpopulate(val, "Result", &c.Result)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComponentBillingFeatures.
func (c ComponentBillingFeatures) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "CurrentBillingFeatures", c.CurrentBillingFeatures)
	populate(objectMap, "DataVolumeCap", c.DataVolumeCap)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComponentBillingFeatures.
func (c *ComponentBillingFeatures) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "CurrentBillingFeatures":
			err = unpopulate(val, "CurrentBillingFeatures", &c.CurrentBillingFeatures)
			delete(rawMsg, key)
		case "DataVolumeCap":
			err = unpopulate(val, "DataVolumeCap", &c.DataVolumeCap)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComponentDataVolumeCap.
func (c ComponentDataVolumeCap) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "Cap", c.Cap)
	populate(objectMap, "MaxHistoryCap", c.MaxHistoryCap)
	populate(objectMap, "ResetTime", c.ResetTime)
	populate(objectMap, "StopSendNotificationWhenHitCap", c.StopSendNotificationWhenHitCap)
	populate(objectMap, "StopSendNotificationWhenHitThreshold", c.StopSendNotificationWhenHitThreshold)
	populate(objectMap, "WarningThreshold", c.WarningThreshold)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComponentDataVolumeCap.
func (c *ComponentDataVolumeCap) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "Cap":
			err = unpopulate(val, "Cap", &c.Cap)
			delete(rawMsg, key)
		case "MaxHistoryCap":
			err = unpopulate(val, "MaxHistoryCap", &c.MaxHistoryCap)
			delete(rawMsg, key)
		case "ResetTime":
			err = unpopulate(val, "ResetTime", &c.ResetTime)
			delete(rawMsg, key)
		case "StopSendNotificationWhenHitCap":
			err = unpopulate(val, "StopSendNotificationWhenHitCap", &c.StopSendNotificationWhenHitCap)
			delete(rawMsg, key)
		case "StopSendNotificationWhenHitThreshold":
			err = unpopulate(val, "StopSendNotificationWhenHitThreshold", &c.StopSendNotificationWhenHitThreshold)
			delete(rawMsg, key)
		case "WarningThreshold":
			err = unpopulate(val, "WarningThreshold", &c.WarningThreshold)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComponentExportConfiguration.
func (c ComponentExportConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ApplicationName", c.ApplicationName)
	populate(objectMap, "ContainerName", c.ContainerName)
	populate(objectMap, "DestinationAccountId", c.DestinationAccountID)
	populate(objectMap, "DestinationStorageLocationId", c.DestinationStorageLocationID)
	populate(objectMap, "DestinationStorageSubscriptionId", c.DestinationStorageSubscriptionID)
	populate(objectMap, "DestinationType", c.DestinationType)
	populate(objectMap, "ExportId", c.ExportID)
	populate(objectMap, "ExportStatus", c.ExportStatus)
	populate(objectMap, "InstrumentationKey", c.InstrumentationKey)
	populate(objectMap, "IsUserEnabled", c.IsUserEnabled)
	populate(objectMap, "LastGapTime", c.LastGapTime)
	populate(objectMap, "LastSuccessTime", c.LastSuccessTime)
	populate(objectMap, "LastUserUpdate", c.LastUserUpdate)
	populate(objectMap, "NotificationQueueEnabled", c.NotificationQueueEnabled)
	populate(objectMap, "PermanentErrorReason", c.PermanentErrorReason)
	populate(objectMap, "RecordTypes", c.RecordTypes)
	populate(objectMap, "ResourceGroup", c.ResourceGroup)
	populate(objectMap, "StorageName", c.StorageName)
	populate(objectMap, "SubscriptionId", c.SubscriptionID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComponentExportConfiguration.
func (c *ComponentExportConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ApplicationName":
			err = unpopulate(val, "ApplicationName", &c.ApplicationName)
			delete(rawMsg, key)
		case "ContainerName":
			err = unpopulate(val, "ContainerName", &c.ContainerName)
			delete(rawMsg, key)
		case "DestinationAccountId":
			err = unpopulate(val, "DestinationAccountID", &c.DestinationAccountID)
			delete(rawMsg, key)
		case "DestinationStorageLocationId":
			err = unpopulate(val, "DestinationStorageLocationID", &c.DestinationStorageLocationID)
			delete(rawMsg, key)
		case "DestinationStorageSubscriptionId":
			err = unpopulate(val, "DestinationStorageSubscriptionID", &c.DestinationStorageSubscriptionID)
			delete(rawMsg, key)
		case "DestinationType":
			err = unpopulate(val, "DestinationType", &c.DestinationType)
			delete(rawMsg, key)
		case "ExportId":
			err = unpopulate(val, "ExportID", &c.ExportID)
			delete(rawMsg, key)
		case "ExportStatus":
			err = unpopulate(val, "ExportStatus", &c.ExportStatus)
			delete(rawMsg, key)
		case "InstrumentationKey":
			err = unpopulate(val, "InstrumentationKey", &c.InstrumentationKey)
			delete(rawMsg, key)
		case "IsUserEnabled":
			err = unpopulate(val, "IsUserEnabled", &c.IsUserEnabled)
			delete(rawMsg, key)
		case "LastGapTime":
			err = unpopulate(val, "LastGapTime", &c.LastGapTime)
			delete(rawMsg, key)
		case "LastSuccessTime":
			err = unpopulate(val, "LastSuccessTime", &c.LastSuccessTime)
			delete(rawMsg, key)
		case "LastUserUpdate":
			err = unpopulate(val, "LastUserUpdate", &c.LastUserUpdate)
			delete(rawMsg, key)
		case "NotificationQueueEnabled":
			err = unpopulate(val, "NotificationQueueEnabled", &c.NotificationQueueEnabled)
			delete(rawMsg, key)
		case "PermanentErrorReason":
			err = unpopulate(val, "PermanentErrorReason", &c.PermanentErrorReason)
			delete(rawMsg, key)
		case "RecordTypes":
			err = unpopulate(val, "RecordTypes", &c.RecordTypes)
			delete(rawMsg, key)
		case "ResourceGroup":
			err = unpopulate(val, "ResourceGroup", &c.ResourceGroup)
			delete(rawMsg, key)
		case "StorageName":
			err = unpopulate(val, "StorageName", &c.StorageName)
			delete(rawMsg, key)
		case "SubscriptionId":
			err = unpopulate(val, "SubscriptionID", &c.SubscriptionID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComponentExportRequest.
func (c ComponentExportRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "DestinationAccountId", c.DestinationAccountID)
	populate(objectMap, "DestinationAddress", c.DestinationAddress)
	populate(objectMap, "DestinationStorageLocationId", c.DestinationStorageLocationID)
	populate(objectMap, "DestinationStorageSubscriptionId", c.DestinationStorageSubscriptionID)
	populate(objectMap, "DestinationType", c.DestinationType)
	populate(objectMap, "IsEnabled", c.IsEnabled)
	populate(objectMap, "NotificationQueueEnabled", c.NotificationQueueEnabled)
	populate(objectMap, "NotificationQueueUri", c.NotificationQueueURI)
	populate(objectMap, "RecordTypes", c.RecordTypes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComponentExportRequest.
func (c *ComponentExportRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "DestinationAccountId":
			err = unpopulate(val, "DestinationAccountID", &c.DestinationAccountID)
			delete(rawMsg, key)
		case "DestinationAddress":
			err = unpopulate(val, "DestinationAddress", &c.DestinationAddress)
			delete(rawMsg, key)
		case "DestinationStorageLocationId":
			err = unpopulate(val, "DestinationStorageLocationID", &c.DestinationStorageLocationID)
			delete(rawMsg, key)
		case "DestinationStorageSubscriptionId":
			err = unpopulate(val, "DestinationStorageSubscriptionID", &c.DestinationStorageSubscriptionID)
			delete(rawMsg, key)
		case "DestinationType":
			err = unpopulate(val, "DestinationType", &c.DestinationType)
			delete(rawMsg, key)
		case "IsEnabled":
			err = unpopulate(val, "IsEnabled", &c.IsEnabled)
			delete(rawMsg, key)
		case "NotificationQueueEnabled":
			err = unpopulate(val, "NotificationQueueEnabled", &c.NotificationQueueEnabled)
			delete(rawMsg, key)
		case "NotificationQueueUri":
			err = unpopulate(val, "NotificationQueueURI", &c.NotificationQueueURI)
			delete(rawMsg, key)
		case "RecordTypes":
			err = unpopulate(val, "RecordTypes", &c.RecordTypes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComponentFavorite.
func (c ComponentFavorite) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "Category", c.Category)
	populate(objectMap, "Config", c.Config)
	populate(objectMap, "FavoriteId", c.FavoriteID)
	populate(objectMap, "FavoriteType", c.FavoriteType)
	populate(objectMap, "IsGeneratedFromTemplate", c.IsGeneratedFromTemplate)
	populate(objectMap, "Name", c.Name)
	populate(objectMap, "SourceType", c.SourceType)
	populate(objectMap, "Tags", c.Tags)
	populate(objectMap, "TimeModified", c.TimeModified)
	populate(objectMap, "UserId", c.UserID)
	populate(objectMap, "Version", c.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComponentFavorite.
func (c *ComponentFavorite) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "Category":
			err = unpopulate(val, "Category", &c.Category)
			delete(rawMsg, key)
		case "Config":
			err = unpopulate(val, "Config", &c.Config)
			delete(rawMsg, key)
		case "FavoriteId":
			err = unpopulate(val, "FavoriteID", &c.FavoriteID)
			delete(rawMsg, key)
		case "FavoriteType":
			err = unpopulate(val, "FavoriteType", &c.FavoriteType)
			delete(rawMsg, key)
		case "IsGeneratedFromTemplate":
			err = unpopulate(val, "IsGeneratedFromTemplate", &c.IsGeneratedFromTemplate)
			delete(rawMsg, key)
		case "Name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "SourceType":
			err = unpopulate(val, "SourceType", &c.SourceType)
			delete(rawMsg, key)
		case "Tags":
			err = unpopulate(val, "Tags", &c.Tags)
			delete(rawMsg, key)
		case "TimeModified":
			err = unpopulate(val, "TimeModified", &c.TimeModified)
			delete(rawMsg, key)
		case "UserId":
			err = unpopulate(val, "UserID", &c.UserID)
			delete(rawMsg, key)
		case "Version":
			err = unpopulate(val, "Version", &c.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComponentFeature.
func (c ComponentFeature) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "Capabilities", c.Capabilities)
	populate(objectMap, "FeatureName", c.FeatureName)
	populate(objectMap, "IsHidden", c.IsHidden)
	populate(objectMap, "IsMainFeature", c.IsMainFeature)
	populate(objectMap, "MeterId", c.MeterID)
	populate(objectMap, "MeterRateFrequency", c.MeterRateFrequency)
	populate(objectMap, "ResouceId", c.ResouceID)
	populate(objectMap, "SupportedAddonFeatures", c.SupportedAddonFeatures)
	populate(objectMap, "Title", c.Title)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComponentFeature.
func (c *ComponentFeature) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "Capabilities":
			err = unpopulate(val, "Capabilities", &c.Capabilities)
			delete(rawMsg, key)
		case "FeatureName":
			err = unpopulate(val, "FeatureName", &c.FeatureName)
			delete(rawMsg, key)
		case "IsHidden":
			err = unpopulate(val, "IsHidden", &c.IsHidden)
			delete(rawMsg, key)
		case "IsMainFeature":
			err = unpopulate(val, "IsMainFeature", &c.IsMainFeature)
			delete(rawMsg, key)
		case "MeterId":
			err = unpopulate(val, "MeterID", &c.MeterID)
			delete(rawMsg, key)
		case "MeterRateFrequency":
			err = unpopulate(val, "MeterRateFrequency", &c.MeterRateFrequency)
			delete(rawMsg, key)
		case "ResouceId":
			err = unpopulate(val, "ResouceID", &c.ResouceID)
			delete(rawMsg, key)
		case "SupportedAddonFeatures":
			err = unpopulate(val, "SupportedAddonFeatures", &c.SupportedAddonFeatures)
			delete(rawMsg, key)
		case "Title":
			err = unpopulate(val, "Title", &c.Title)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComponentFeatureCapabilities.
func (c ComponentFeatureCapabilities) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ApiAccessLevel", c.APIAccessLevel)
	populate(objectMap, "AnalyticsIntegration", c.AnalyticsIntegration)
	populate(objectMap, "ApplicationMap", c.ApplicationMap)
	populate(objectMap, "BurstThrottlePolicy", c.BurstThrottlePolicy)
	populate(objectMap, "DailyCap", c.DailyCap)
	populate(objectMap, "DailyCapResetTime", c.DailyCapResetTime)
	populate(objectMap, "LiveStreamMetrics", c.LiveStreamMetrics)
	populate(objectMap, "MetadataClass", c.MetadataClass)
	populate(objectMap, "MultipleStepWebTest", c.MultipleStepWebTest)
	populate(objectMap, "OpenSchema", c.OpenSchema)
	populate(objectMap, "PowerBIIntegration", c.PowerBIIntegration)
	populate(objectMap, "ProactiveDetection", c.ProactiveDetection)
	populate(objectMap, "SupportExportData", c.SupportExportData)
	populate(objectMap, "ThrottleRate", c.ThrottleRate)
	populate(objectMap, "TrackingType", c.TrackingType)
	populate(objectMap, "WorkItemIntegration", c.WorkItemIntegration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComponentFeatureCapabilities.
func (c *ComponentFeatureCapabilities) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ApiAccessLevel":
			err = unpopulate(val, "APIAccessLevel", &c.APIAccessLevel)
			delete(rawMsg, key)
		case "AnalyticsIntegration":
			err = unpopulate(val, "AnalyticsIntegration", &c.AnalyticsIntegration)
			delete(rawMsg, key)
		case "ApplicationMap":
			err = unpopulate(val, "ApplicationMap", &c.ApplicationMap)
			delete(rawMsg, key)
		case "BurstThrottlePolicy":
			err = unpopulate(val, "BurstThrottlePolicy", &c.BurstThrottlePolicy)
			delete(rawMsg, key)
		case "DailyCap":
			err = unpopulate(val, "DailyCap", &c.DailyCap)
			delete(rawMsg, key)
		case "DailyCapResetTime":
			err = unpopulate(val, "DailyCapResetTime", &c.DailyCapResetTime)
			delete(rawMsg, key)
		case "LiveStreamMetrics":
			err = unpopulate(val, "LiveStreamMetrics", &c.LiveStreamMetrics)
			delete(rawMsg, key)
		case "MetadataClass":
			err = unpopulate(val, "MetadataClass", &c.MetadataClass)
			delete(rawMsg, key)
		case "MultipleStepWebTest":
			err = unpopulate(val, "MultipleStepWebTest", &c.MultipleStepWebTest)
			delete(rawMsg, key)
		case "OpenSchema":
			err = unpopulate(val, "OpenSchema", &c.OpenSchema)
			delete(rawMsg, key)
		case "PowerBIIntegration":
			err = unpopulate(val, "PowerBIIntegration", &c.PowerBIIntegration)
			delete(rawMsg, key)
		case "ProactiveDetection":
			err = unpopulate(val, "ProactiveDetection", &c.ProactiveDetection)
			delete(rawMsg, key)
		case "SupportExportData":
			err = unpopulate(val, "SupportExportData", &c.SupportExportData)
			delete(rawMsg, key)
		case "ThrottleRate":
			err = unpopulate(val, "ThrottleRate", &c.ThrottleRate)
			delete(rawMsg, key)
		case "TrackingType":
			err = unpopulate(val, "TrackingType", &c.TrackingType)
			delete(rawMsg, key)
		case "WorkItemIntegration":
			err = unpopulate(val, "WorkItemIntegration", &c.WorkItemIntegration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComponentFeatureCapability.
func (c ComponentFeatureCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "Description", c.Description)
	populate(objectMap, "MeterId", c.MeterID)
	populate(objectMap, "MeterRateFrequency", c.MeterRateFrequency)
	populate(objectMap, "Name", c.Name)
	populate(objectMap, "Unit", c.Unit)
	populate(objectMap, "Value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComponentFeatureCapability.
func (c *ComponentFeatureCapability) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "Description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "MeterId":
			err = unpopulate(val, "MeterID", &c.MeterID)
			delete(rawMsg, key)
		case "MeterRateFrequency":
			err = unpopulate(val, "MeterRateFrequency", &c.MeterRateFrequency)
			delete(rawMsg, key)
		case "Name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "Unit":
			err = unpopulate(val, "Unit", &c.Unit)
			delete(rawMsg, key)
		case "Value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComponentListResult.
func (c ComponentListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComponentListResult.
func (c *ComponentListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComponentProactiveDetectionConfiguration.
func (c ComponentProactiveDetectionConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "CustomEmails", c.CustomEmails)
	populate(objectMap, "Enabled", c.Enabled)
	populate(objectMap, "LastUpdatedTime", c.LastUpdatedTime)
	populate(objectMap, "Name", c.Name)
	populate(objectMap, "RuleDefinitions", c.RuleDefinitions)
	populate(objectMap, "SendEmailsToSubscriptionOwners", c.SendEmailsToSubscriptionOwners)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComponentProactiveDetectionConfiguration.
func (c *ComponentProactiveDetectionConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "CustomEmails":
			err = unpopulate(val, "CustomEmails", &c.CustomEmails)
			delete(rawMsg, key)
		case "Enabled":
			err = unpopulate(val, "Enabled", &c.Enabled)
			delete(rawMsg, key)
		case "LastUpdatedTime":
			err = unpopulate(val, "LastUpdatedTime", &c.LastUpdatedTime)
			delete(rawMsg, key)
		case "Name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "RuleDefinitions":
			err = unpopulate(val, "RuleDefinitions", &c.RuleDefinitions)
			delete(rawMsg, key)
		case "SendEmailsToSubscriptionOwners":
			err = unpopulate(val, "SendEmailsToSubscriptionOwners", &c.SendEmailsToSubscriptionOwners)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComponentProactiveDetectionConfigurationRuleDefinitions.
func (c ComponentProactiveDetectionConfigurationRuleDefinitions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "Description", c.Description)
	populate(objectMap, "DisplayName", c.DisplayName)
	populate(objectMap, "HelpUrl", c.HelpURL)
	populate(objectMap, "IsEnabledByDefault", c.IsEnabledByDefault)
	populate(objectMap, "IsHidden", c.IsHidden)
	populate(objectMap, "IsInPreview", c.IsInPreview)
	populate(objectMap, "Name", c.Name)
	populate(objectMap, "SupportsEmailNotifications", c.SupportsEmailNotifications)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComponentProactiveDetectionConfigurationRuleDefinitions.
func (c *ComponentProactiveDetectionConfigurationRuleDefinitions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "Description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "DisplayName":
			err = unpopulate(val, "DisplayName", &c.DisplayName)
			delete(rawMsg, key)
		case "HelpUrl":
			err = unpopulate(val, "HelpURL", &c.HelpURL)
			delete(rawMsg, key)
		case "IsEnabledByDefault":
			err = unpopulate(val, "IsEnabledByDefault", &c.IsEnabledByDefault)
			delete(rawMsg, key)
		case "IsHidden":
			err = unpopulate(val, "IsHidden", &c.IsHidden)
			delete(rawMsg, key)
		case "IsInPreview":
			err = unpopulate(val, "IsInPreview", &c.IsInPreview)
			delete(rawMsg, key)
		case "Name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "SupportsEmailNotifications":
			err = unpopulate(val, "SupportsEmailNotifications", &c.SupportsEmailNotifications)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComponentProperties.
func (c ComponentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "AppId", c.AppID)
	populate(objectMap, "ApplicationId", c.ApplicationID)
	populate(objectMap, "Application_Type", c.ApplicationType)
	populate(objectMap, "ConnectionString", c.ConnectionString)
	populateDateTimeRFC3339(objectMap, "CreationDate", c.CreationDate)
	populate(objectMap, "DisableIpMasking", c.DisableIPMasking)
	populate(objectMap, "DisableLocalAuth", c.DisableLocalAuth)
	populate(objectMap, "Flow_Type", c.FlowType)
	populate(objectMap, "ForceCustomerStorageForProfiler", c.ForceCustomerStorageForProfiler)
	populate(objectMap, "HockeyAppId", c.HockeyAppID)
	populate(objectMap, "HockeyAppToken", c.HockeyAppToken)
	populate(objectMap, "ImmediatePurgeDataOn30Days", c.ImmediatePurgeDataOn30Days)
	populate(objectMap, "IngestionMode", c.IngestionMode)
	populate(objectMap, "InstrumentationKey", c.InstrumentationKey)
	populateDateTimeRFC3339(objectMap, "LaMigrationDate", c.LaMigrationDate)
	populate(objectMap, "Name", c.Name)
	populate(objectMap, "PrivateLinkScopedResources", c.PrivateLinkScopedResources)
	populate(objectMap, "provisioningState", c.ProvisioningState)
	populate(objectMap, "publicNetworkAccessForIngestion", c.PublicNetworkAccessForIngestion)
	populate(objectMap, "publicNetworkAccessForQuery", c.PublicNetworkAccessForQuery)
	populate(objectMap, "Request_Source", c.RequestSource)
	populate(objectMap, "RetentionInDays", c.RetentionInDays)
	populate(objectMap, "SamplingPercentage", c.SamplingPercentage)
	populate(objectMap, "TenantId", c.TenantID)
	populate(objectMap, "WorkspaceResourceId", c.WorkspaceResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComponentProperties.
func (c *ComponentProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "AppId":
			err = unpopulate(val, "AppID", &c.AppID)
			delete(rawMsg, key)
		case "ApplicationId":
			err = unpopulate(val, "ApplicationID", &c.ApplicationID)
			delete(rawMsg, key)
		case "Application_Type":
			err = unpopulate(val, "ApplicationType", &c.ApplicationType)
			delete(rawMsg, key)
		case "ConnectionString":
			err = unpopulate(val, "ConnectionString", &c.ConnectionString)
			delete(rawMsg, key)
		case "CreationDate":
			err = unpopulateDateTimeRFC3339(val, "CreationDate", &c.CreationDate)
			delete(rawMsg, key)
		case "DisableIpMasking":
			err = unpopulate(val, "DisableIPMasking", &c.DisableIPMasking)
			delete(rawMsg, key)
		case "DisableLocalAuth":
			err = unpopulate(val, "DisableLocalAuth", &c.DisableLocalAuth)
			delete(rawMsg, key)
		case "Flow_Type":
			err = unpopulate(val, "FlowType", &c.FlowType)
			delete(rawMsg, key)
		case "ForceCustomerStorageForProfiler":
			err = unpopulate(val, "ForceCustomerStorageForProfiler", &c.ForceCustomerStorageForProfiler)
			delete(rawMsg, key)
		case "HockeyAppId":
			err = unpopulate(val, "HockeyAppID", &c.HockeyAppID)
			delete(rawMsg, key)
		case "HockeyAppToken":
			err = unpopulate(val, "HockeyAppToken", &c.HockeyAppToken)
			delete(rawMsg, key)
		case "ImmediatePurgeDataOn30Days":
			err = unpopulate(val, "ImmediatePurgeDataOn30Days", &c.ImmediatePurgeDataOn30Days)
			delete(rawMsg, key)
		case "IngestionMode":
			err = unpopulate(val, "IngestionMode", &c.IngestionMode)
			delete(rawMsg, key)
		case "InstrumentationKey":
			err = unpopulate(val, "InstrumentationKey", &c.InstrumentationKey)
			delete(rawMsg, key)
		case "LaMigrationDate":
			err = unpopulateDateTimeRFC3339(val, "LaMigrationDate", &c.LaMigrationDate)
			delete(rawMsg, key)
		case "Name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "PrivateLinkScopedResources":
			err = unpopulate(val, "PrivateLinkScopedResources", &c.PrivateLinkScopedResources)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &c.ProvisioningState)
			delete(rawMsg, key)
		case "publicNetworkAccessForIngestion":
			err = unpopulate(val, "PublicNetworkAccessForIngestion", &c.PublicNetworkAccessForIngestion)
			delete(rawMsg, key)
		case "publicNetworkAccessForQuery":
			err = unpopulate(val, "PublicNetworkAccessForQuery", &c.PublicNetworkAccessForQuery)
			delete(rawMsg, key)
		case "Request_Source":
			err = unpopulate(val, "RequestSource", &c.RequestSource)
			delete(rawMsg, key)
		case "RetentionInDays":
			err = unpopulate(val, "RetentionInDays", &c.RetentionInDays)
			delete(rawMsg, key)
		case "SamplingPercentage":
			err = unpopulate(val, "SamplingPercentage", &c.SamplingPercentage)
			delete(rawMsg, key)
		case "TenantId":
			err = unpopulate(val, "TenantID", &c.TenantID)
			delete(rawMsg, key)
		case "WorkspaceResourceId":
			err = unpopulate(val, "WorkspaceResourceID", &c.WorkspaceResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComponentPurgeBody.
func (c ComponentPurgeBody) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "filters", c.Filters)
	populate(objectMap, "table", c.Table)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComponentPurgeBody.
func (c *ComponentPurgeBody) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "filters":
			err = unpopulate(val, "Filters", &c.Filters)
			delete(rawMsg, key)
		case "table":
			err = unpopulate(val, "Table", &c.Table)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComponentPurgeBodyFilters.
func (c ComponentPurgeBodyFilters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "column", c.Column)
	populate(objectMap, "key", c.Key)
	populate(objectMap, "operator", c.Operator)
	populateAny(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComponentPurgeBodyFilters.
func (c *ComponentPurgeBodyFilters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "column":
			err = unpopulate(val, "Column", &c.Column)
			delete(rawMsg, key)
		case "key":
			err = unpopulate(val, "Key", &c.Key)
			delete(rawMsg, key)
		case "operator":
			err = unpopulate(val, "Operator", &c.Operator)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComponentPurgeResponse.
func (c ComponentPurgeResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "operationId", c.OperationID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComponentPurgeResponse.
func (c *ComponentPurgeResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "operationId":
			err = unpopulate(val, "OperationID", &c.OperationID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComponentPurgeStatusResponse.
func (c ComponentPurgeStatusResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "status", c.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComponentPurgeStatusResponse.
func (c *ComponentPurgeStatusResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "status":
			err = unpopulate(val, "Status", &c.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComponentQuotaStatus.
func (c ComponentQuotaStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "AppId", c.AppID)
	populate(objectMap, "ExpirationTime", c.ExpirationTime)
	populate(objectMap, "ShouldBeThrottled", c.ShouldBeThrottled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComponentQuotaStatus.
func (c *ComponentQuotaStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "AppId":
			err = unpopulate(val, "AppID", &c.AppID)
			delete(rawMsg, key)
		case "ExpirationTime":
			err = unpopulate(val, "ExpirationTime", &c.ExpirationTime)
			delete(rawMsg, key)
		case "ShouldBeThrottled":
			err = unpopulate(val, "ShouldBeThrottled", &c.ShouldBeThrottled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComponentWebTestLocation.
func (c ComponentWebTestLocation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "DisplayName", c.DisplayName)
	populate(objectMap, "Tag", c.Tag)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComponentWebTestLocation.
func (c *ComponentWebTestLocation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "DisplayName":
			err = unpopulate(val, "DisplayName", &c.DisplayName)
			delete(rawMsg, key)
		case "Tag":
			err = unpopulate(val, "Tag", &c.Tag)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComponentsResource.
func (c ComponentsResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "location", c.Location)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "tags", c.Tags)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComponentsResource.
func (c *ComponentsResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &c.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &c.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorFieldContract.
func (e ErrorFieldContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "message", e.Message)
	populate(objectMap, "target", e.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorFieldContract.
func (e *ErrorFieldContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &e.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorResponse.
func (e ErrorResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "message", e.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorResponse.
func (e *ErrorResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorResponseComponents.
func (e ErrorResponseComponents) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", e.Error)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorResponseComponents.
func (e *ErrorResponseComponents) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &e.Error)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorResponseComponentsError.
func (e ErrorResponseComponentsError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "message", e.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorResponseComponentsError.
func (e *ErrorResponseComponentsError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InnerError.
func (i InnerError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "diagnosticcontext", i.Diagnosticcontext)
	populateDateTimeRFC3339(objectMap, "time", i.Time)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InnerError.
func (i *InnerError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diagnosticcontext":
			err = unpopulate(val, "Diagnosticcontext", &i.Diagnosticcontext)
			delete(rawMsg, key)
		case "time":
			err = unpopulateDateTimeRFC3339(val, "Time", &i.Time)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LinkProperties.
func (l LinkProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "category", l.Category)
	populate(objectMap, "sourceId", l.SourceID)
	populate(objectMap, "targetId", l.TargetID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LinkProperties.
func (l *LinkProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "category":
			err = unpopulate(val, "Category", &l.Category)
			delete(rawMsg, key)
		case "sourceId":
			err = unpopulate(val, "SourceID", &l.SourceID)
			delete(rawMsg, key)
		case "targetId":
			err = unpopulate(val, "TargetID", &l.TargetID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MyWorkbook.
func (m MyWorkbook) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "kind", m.Kind)
	populate(objectMap, "location", m.Location)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "tags", m.Tags)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MyWorkbook.
func (m *MyWorkbook) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &m.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &m.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &m.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MyWorkbookError.
func (m MyWorkbookError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", m.Code)
	populate(objectMap, "details", m.Details)
	populate(objectMap, "message", m.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MyWorkbookError.
func (m *MyWorkbookError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &m.Code)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &m.Details)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &m.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MyWorkbookProperties.
func (m MyWorkbookProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "category", m.Category)
	populate(objectMap, "displayName", m.DisplayName)
	populate(objectMap, "serializedData", m.SerializedData)
	populate(objectMap, "sourceId", m.SourceID)
	populate(objectMap, "tags", m.Tags)
	populate(objectMap, "timeModified", m.TimeModified)
	populate(objectMap, "userId", m.UserID)
	populate(objectMap, "version", m.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MyWorkbookProperties.
func (m *MyWorkbookProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "category":
			err = unpopulate(val, "Category", &m.Category)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &m.DisplayName)
			delete(rawMsg, key)
		case "serializedData":
			err = unpopulate(val, "SerializedData", &m.SerializedData)
			delete(rawMsg, key)
		case "sourceId":
			err = unpopulate(val, "SourceID", &m.SourceID)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &m.Tags)
			delete(rawMsg, key)
		case "timeModified":
			err = unpopulate(val, "TimeModified", &m.TimeModified)
			delete(rawMsg, key)
		case "userId":
			err = unpopulate(val, "UserID", &m.UserID)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &m.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MyWorkbookResource.
func (m MyWorkbookResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "location", m.Location)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "tags", m.Tags)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MyWorkbookResource.
func (m *MyWorkbookResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &m.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &m.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MyWorkbooksListResult.
func (m MyWorkbooksListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", m.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MyWorkbooksListResult.
func (m *MyWorkbooksListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &m.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "display", o.Display)
	populate(objectMap, "name", o.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Operation.
func (o *Operation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "display":
			err = unpopulate(val, "Display", &o.Display)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationDisplay.
func (o OperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "operation", o.Operation)
	populate(objectMap, "provider", o.Provider)
	populate(objectMap, "resource", o.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationDisplay.
func (o *OperationDisplay) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "operation":
			err = unpopulate(val, "Operation", &o.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &o.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &o.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationListResult.
func (o OperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationListResult.
func (o *OperationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &o.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkScopedResource.
func (p PrivateLinkScopedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ResourceId", p.ResourceID)
	populate(objectMap, "ScopeId", p.ScopeID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkScopedResource.
func (p *PrivateLinkScopedResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ResourceId":
			err = unpopulate(val, "ResourceID", &p.ResourceID)
			delete(rawMsg, key)
		case "ScopeId":
			err = unpopulate(val, "ScopeID", &p.ScopeID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TagsResource.
func (t TagsResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "tags", t.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TagsResource.
func (t *TagsResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tags":
			err = unpopulate(val, "Tags", &t.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WebTest.
func (w WebTest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", w.ID)
	populate(objectMap, "kind", w.Kind)
	populate(objectMap, "location", w.Location)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "properties", w.Properties)
	populate(objectMap, "tags", w.Tags)
	populate(objectMap, "type", w.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WebTest.
func (w *WebTest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &w.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &w.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &w.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &w.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &w.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &w.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WebTestGeolocation.
func (w WebTestGeolocation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "Id", w.Location)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WebTestGeolocation.
func (w *WebTestGeolocation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "Id":
			err = unpopulate(val, "Location", &w.Location)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WebTestListResult.
func (w WebTestListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", w.NextLink)
	populate(objectMap, "value", w.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WebTestListResult.
func (w *WebTestListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &w.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &w.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WebTestLocationsListResult.
func (w WebTestLocationsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", w.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WebTestLocationsListResult.
func (w *WebTestLocationsListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &w.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WebTestProperties.
func (w WebTestProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "Configuration", w.Configuration)
	populate(objectMap, "Description", w.Description)
	populate(objectMap, "Enabled", w.Enabled)
	populate(objectMap, "Frequency", w.Frequency)
	populate(objectMap, "Locations", w.Locations)
	populate(objectMap, "provisioningState", w.ProvisioningState)
	populate(objectMap, "RetryEnabled", w.RetryEnabled)
	populate(objectMap, "SyntheticMonitorId", w.SyntheticMonitorID)
	populate(objectMap, "Timeout", w.Timeout)
	populate(objectMap, "Kind", w.WebTestKind)
	populate(objectMap, "Name", w.WebTestName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WebTestProperties.
func (w *WebTestProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "Configuration":
			err = unpopulate(val, "Configuration", &w.Configuration)
			delete(rawMsg, key)
		case "Description":
			err = unpopulate(val, "Description", &w.Description)
			delete(rawMsg, key)
		case "Enabled":
			err = unpopulate(val, "Enabled", &w.Enabled)
			delete(rawMsg, key)
		case "Frequency":
			err = unpopulate(val, "Frequency", &w.Frequency)
			delete(rawMsg, key)
		case "Locations":
			err = unpopulate(val, "Locations", &w.Locations)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &w.ProvisioningState)
			delete(rawMsg, key)
		case "RetryEnabled":
			err = unpopulate(val, "RetryEnabled", &w.RetryEnabled)
			delete(rawMsg, key)
		case "SyntheticMonitorId":
			err = unpopulate(val, "SyntheticMonitorID", &w.SyntheticMonitorID)
			delete(rawMsg, key)
		case "Timeout":
			err = unpopulate(val, "Timeout", &w.Timeout)
			delete(rawMsg, key)
		case "Kind":
			err = unpopulate(val, "WebTestKind", &w.WebTestKind)
			delete(rawMsg, key)
		case "Name":
			err = unpopulate(val, "WebTestName", &w.WebTestName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WebTestPropertiesConfiguration.
func (w WebTestPropertiesConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "WebTest", w.WebTest)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WebTestPropertiesConfiguration.
func (w *WebTestPropertiesConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "WebTest":
			err = unpopulate(val, "WebTest", &w.WebTest)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WebtestsResource.
func (w WebtestsResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", w.ID)
	populate(objectMap, "location", w.Location)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "tags", w.Tags)
	populate(objectMap, "type", w.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WebtestsResource.
func (w *WebtestsResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &w.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &w.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &w.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &w.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkItemConfiguration.
func (w WorkItemConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ConfigDisplayName", w.ConfigDisplayName)
	populate(objectMap, "ConfigProperties", w.ConfigProperties)
	populate(objectMap, "ConnectorId", w.ConnectorID)
	populate(objectMap, "Id", w.ID)
	populate(objectMap, "IsDefault", w.IsDefault)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkItemConfiguration.
func (w *WorkItemConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ConfigDisplayName":
			err = unpopulate(val, "ConfigDisplayName", &w.ConfigDisplayName)
			delete(rawMsg, key)
		case "ConfigProperties":
			err = unpopulate(val, "ConfigProperties", &w.ConfigProperties)
			delete(rawMsg, key)
		case "ConnectorId":
			err = unpopulate(val, "ConnectorID", &w.ConnectorID)
			delete(rawMsg, key)
		case "Id":
			err = unpopulate(val, "ID", &w.ID)
			delete(rawMsg, key)
		case "IsDefault":
			err = unpopulate(val, "IsDefault", &w.IsDefault)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkItemConfigurationError.
func (w WorkItemConfigurationError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", w.Code)
	populate(objectMap, "innererror", w.Innererror)
	populate(objectMap, "message", w.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkItemConfigurationError.
func (w *WorkItemConfigurationError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &w.Code)
			delete(rawMsg, key)
		case "innererror":
			err = unpopulate(val, "Innererror", &w.Innererror)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &w.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkItemConfigurationsListResult.
func (w WorkItemConfigurationsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", w.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkItemConfigurationsListResult.
func (w *WorkItemConfigurationsListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &w.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkItemCreateConfiguration.
func (w WorkItemCreateConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ConnectorDataConfiguration", w.ConnectorDataConfiguration)
	populate(objectMap, "ConnectorId", w.ConnectorID)
	populate(objectMap, "ValidateOnly", w.ValidateOnly)
	populate(objectMap, "WorkItemProperties", w.WorkItemProperties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkItemCreateConfiguration.
func (w *WorkItemCreateConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ConnectorDataConfiguration":
			err = unpopulate(val, "ConnectorDataConfiguration", &w.ConnectorDataConfiguration)
			delete(rawMsg, key)
		case "ConnectorId":
			err = unpopulate(val, "ConnectorID", &w.ConnectorID)
			delete(rawMsg, key)
		case "ValidateOnly":
			err = unpopulate(val, "ValidateOnly", &w.ValidateOnly)
			delete(rawMsg, key)
		case "WorkItemProperties":
			err = unpopulate(val, "WorkItemProperties", &w.WorkItemProperties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Workbook.
func (w Workbook) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", w.ID)
	populate(objectMap, "kind", w.Kind)
	populate(objectMap, "location", w.Location)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "properties", w.Properties)
	populate(objectMap, "tags", w.Tags)
	populate(objectMap, "type", w.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Workbook.
func (w *Workbook) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &w.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &w.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &w.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &w.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &w.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &w.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkbookError.
func (w WorkbookError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", w.Code)
	populate(objectMap, "details", w.Details)
	populate(objectMap, "message", w.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkbookError.
func (w *WorkbookError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &w.Code)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &w.Details)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &w.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkbookProperties.
func (w WorkbookProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "category", w.Category)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "serializedData", w.SerializedData)
	populate(objectMap, "kind", w.SharedTypeKind)
	populate(objectMap, "sourceResourceId", w.SourceResourceID)
	populate(objectMap, "tags", w.Tags)
	populate(objectMap, "timeModified", w.TimeModified)
	populate(objectMap, "userId", w.UserID)
	populate(objectMap, "version", w.Version)
	populate(objectMap, "workbookId", w.WorkbookID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkbookProperties.
func (w *WorkbookProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "category":
			err = unpopulate(val, "Category", &w.Category)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "serializedData":
			err = unpopulate(val, "SerializedData", &w.SerializedData)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "SharedTypeKind", &w.SharedTypeKind)
			delete(rawMsg, key)
		case "sourceResourceId":
			err = unpopulate(val, "SourceResourceID", &w.SourceResourceID)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &w.Tags)
			delete(rawMsg, key)
		case "timeModified":
			err = unpopulate(val, "TimeModified", &w.TimeModified)
			delete(rawMsg, key)
		case "userId":
			err = unpopulate(val, "UserID", &w.UserID)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &w.Version)
			delete(rawMsg, key)
		case "workbookId":
			err = unpopulate(val, "WorkbookID", &w.WorkbookID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkbookResource.
func (w WorkbookResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", w.ID)
	populate(objectMap, "location", w.Location)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "tags", w.Tags)
	populate(objectMap, "type", w.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkbookResource.
func (w *WorkbookResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &w.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &w.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &w.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &w.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkbooksListResult.
func (w WorkbooksListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", w.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkbooksListResult.
func (w *WorkbooksListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &w.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func populateAny(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
