//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armhdinsightcontainers

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
)

// ClientFactory is a client factory used to create any client in this module.
// Don't use this type directly, use NewClientFactory instead.
type ClientFactory struct {
	subscriptionID string
	credential     azcore.TokenCredential
	options        *arm.ClientOptions
}

// NewClientFactory creates a new instance of ClientFactory with the specified values.
// The parameter values will be propagated to any client created from this factory.
//   - subscriptionID - The ID of the target subscription. The value must be an UUID.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClientFactory(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ClientFactory, error) {
	_, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	return &ClientFactory{
		subscriptionID: subscriptionID, credential: credential,
		options: options.Clone(),
	}, nil
}

// NewAvailableClusterPoolVersionsClient creates a new instance of AvailableClusterPoolVersionsClient.
func (c *ClientFactory) NewAvailableClusterPoolVersionsClient() *AvailableClusterPoolVersionsClient {
	subClient, _ := NewAvailableClusterPoolVersionsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewAvailableClusterVersionsClient creates a new instance of AvailableClusterVersionsClient.
func (c *ClientFactory) NewAvailableClusterVersionsClient() *AvailableClusterVersionsClient {
	subClient, _ := NewAvailableClusterVersionsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewClusterJobsClient creates a new instance of ClusterJobsClient.
func (c *ClientFactory) NewClusterJobsClient() *ClusterJobsClient {
	subClient, _ := NewClusterJobsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewClusterPoolsClient creates a new instance of ClusterPoolsClient.
func (c *ClientFactory) NewClusterPoolsClient() *ClusterPoolsClient {
	subClient, _ := NewClusterPoolsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewClustersClient creates a new instance of ClustersClient.
func (c *ClientFactory) NewClustersClient() *ClustersClient {
	subClient, _ := NewClustersClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewLocationsClient creates a new instance of LocationsClient.
func (c *ClientFactory) NewLocationsClient() *LocationsClient {
	subClient, _ := NewLocationsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewOperationsClient creates a new instance of OperationsClient.
func (c *ClientFactory) NewOperationsClient() *OperationsClient {
	subClient, _ := NewOperationsClient(c.credential, c.options)
	return subClient
}
