//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/sql/armsql/v2"
	"net/http"
	"net/url"
	"regexp"
)

// ServerVulnerabilityAssessmentsServer is a fake server for instances of the armsql.ServerVulnerabilityAssessmentsClient type.
type ServerVulnerabilityAssessmentsServer struct {
	// CreateOrUpdate is the fake for method ServerVulnerabilityAssessmentsClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	CreateOrUpdate func(ctx context.Context, resourceGroupName string, serverName string, vulnerabilityAssessmentName armsql.VulnerabilityAssessmentName, parameters armsql.ServerVulnerabilityAssessment, options *armsql.ServerVulnerabilityAssessmentsClientCreateOrUpdateOptions) (resp azfake.Responder[armsql.ServerVulnerabilityAssessmentsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method ServerVulnerabilityAssessmentsClient.Delete
	// HTTP status codes to indicate success: http.StatusOK
	Delete func(ctx context.Context, resourceGroupName string, serverName string, vulnerabilityAssessmentName armsql.VulnerabilityAssessmentName, options *armsql.ServerVulnerabilityAssessmentsClientDeleteOptions) (resp azfake.Responder[armsql.ServerVulnerabilityAssessmentsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method ServerVulnerabilityAssessmentsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, serverName string, vulnerabilityAssessmentName armsql.VulnerabilityAssessmentName, options *armsql.ServerVulnerabilityAssessmentsClientGetOptions) (resp azfake.Responder[armsql.ServerVulnerabilityAssessmentsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByServerPager is the fake for method ServerVulnerabilityAssessmentsClient.NewListByServerPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByServerPager func(resourceGroupName string, serverName string, options *armsql.ServerVulnerabilityAssessmentsClientListByServerOptions) (resp azfake.PagerResponder[armsql.ServerVulnerabilityAssessmentsClientListByServerResponse])
}

// NewServerVulnerabilityAssessmentsServerTransport creates a new instance of ServerVulnerabilityAssessmentsServerTransport with the provided implementation.
// The returned ServerVulnerabilityAssessmentsServerTransport instance is connected to an instance of armsql.ServerVulnerabilityAssessmentsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewServerVulnerabilityAssessmentsServerTransport(srv *ServerVulnerabilityAssessmentsServer) *ServerVulnerabilityAssessmentsServerTransport {
	return &ServerVulnerabilityAssessmentsServerTransport{
		srv:                  srv,
		newListByServerPager: newTracker[azfake.PagerResponder[armsql.ServerVulnerabilityAssessmentsClientListByServerResponse]](),
	}
}

// ServerVulnerabilityAssessmentsServerTransport connects instances of armsql.ServerVulnerabilityAssessmentsClient to instances of ServerVulnerabilityAssessmentsServer.
// Don't use this type directly, use NewServerVulnerabilityAssessmentsServerTransport instead.
type ServerVulnerabilityAssessmentsServerTransport struct {
	srv                  *ServerVulnerabilityAssessmentsServer
	newListByServerPager *tracker[azfake.PagerResponder[armsql.ServerVulnerabilityAssessmentsClientListByServerResponse]]
}

// Do implements the policy.Transporter interface for ServerVulnerabilityAssessmentsServerTransport.
func (s *ServerVulnerabilityAssessmentsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ServerVulnerabilityAssessmentsClient.CreateOrUpdate":
		resp, err = s.dispatchCreateOrUpdate(req)
	case "ServerVulnerabilityAssessmentsClient.Delete":
		resp, err = s.dispatchDelete(req)
	case "ServerVulnerabilityAssessmentsClient.Get":
		resp, err = s.dispatchGet(req)
	case "ServerVulnerabilityAssessmentsClient.NewListByServerPager":
		resp, err = s.dispatchNewListByServerPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *ServerVulnerabilityAssessmentsServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if s.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/vulnerabilityAssessments/(?P<vulnerabilityAssessmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armsql.ServerVulnerabilityAssessment](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
	if err != nil {
		return nil, err
	}
	vulnerabilityAssessmentNameParam, err := parseWithCast(matches[regex.SubexpIndex("vulnerabilityAssessmentName")], func(v string) (armsql.VulnerabilityAssessmentName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armsql.VulnerabilityAssessmentName(p), nil
	})
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.CreateOrUpdate(req.Context(), resourceGroupNameParam, serverNameParam, vulnerabilityAssessmentNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ServerVulnerabilityAssessment, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *ServerVulnerabilityAssessmentsServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if s.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/vulnerabilityAssessments/(?P<vulnerabilityAssessmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
	if err != nil {
		return nil, err
	}
	vulnerabilityAssessmentNameParam, err := parseWithCast(matches[regex.SubexpIndex("vulnerabilityAssessmentName")], func(v string) (armsql.VulnerabilityAssessmentName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armsql.VulnerabilityAssessmentName(p), nil
	})
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Delete(req.Context(), resourceGroupNameParam, serverNameParam, vulnerabilityAssessmentNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *ServerVulnerabilityAssessmentsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if s.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/vulnerabilityAssessments/(?P<vulnerabilityAssessmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
	if err != nil {
		return nil, err
	}
	vulnerabilityAssessmentNameParam, err := parseWithCast(matches[regex.SubexpIndex("vulnerabilityAssessmentName")], func(v string) (armsql.VulnerabilityAssessmentName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armsql.VulnerabilityAssessmentName(p), nil
	})
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Get(req.Context(), resourceGroupNameParam, serverNameParam, vulnerabilityAssessmentNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ServerVulnerabilityAssessment, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *ServerVulnerabilityAssessmentsServerTransport) dispatchNewListByServerPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListByServerPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByServerPager not implemented")}
	}
	newListByServerPager := s.newListByServerPager.get(req)
	if newListByServerPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/vulnerabilityAssessments`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
		if err != nil {
			return nil, err
		}
		resp := s.srv.NewListByServerPager(resourceGroupNameParam, serverNameParam, nil)
		newListByServerPager = &resp
		s.newListByServerPager.add(req, newListByServerPager)
		server.PagerResponderInjectNextLinks(newListByServerPager, req, func(page *armsql.ServerVulnerabilityAssessmentsClientListByServerResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByServerPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListByServerPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByServerPager) {
		s.newListByServerPager.remove(req)
	}
	return resp, nil
}
