# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Mapping, Optional, TYPE_CHECKING, Union, overload

from .._utils.model_base import Model as _Model, rest_field

if TYPE_CHECKING:
    from .. import models as _models


class CloudError(_Model):
    """An error message.

    :ivar error: The error message body.
    :vartype error: ~azure.mgmt.dnsresolver.models.CloudErrorBody
    """

    error: Optional["_models.CloudErrorBody"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error message body."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.CloudErrorBody"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CloudErrorBody(_Model):
    """The body of an error message.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: A description of what caused the error.
    :vartype message: str
    :ivar target: The target resource of the error message.
    :vartype target: str
    :ivar details: Extra error information.
    :vartype details: list[~azure.mgmt.dnsresolver.models.CloudErrorBody]
    """

    code: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A description of what caused the error."""
    target: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The target resource of the error message."""
    details: Optional[list["_models.CloudErrorBody"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Extra error information."""

    @overload
    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        target: Optional[str] = None,
        details: Optional[list["_models.CloudErrorBody"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Resource(_Model):
    """Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.dnsresolver.models.SystemData
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}."""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the resource."""
    type: Optional[str] = rest_field(visibility=["read"])
    """The type of the resource. E.g. \"Microsoft.Compute/virtualMachines\" or
     \"Microsoft.Storage/storageAccounts\"."""
    system_data: Optional["_models.SystemData"] = rest_field(name="systemData", visibility=["read"])
    """Azure Resource Manager metadata containing createdBy and modifiedBy information."""


class TrackedResource(Resource):
    """Tracked Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.dnsresolver.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    location: str = rest_field(visibility=["read", "create"])
    """The geo-location where the resource lives. Required."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DnsForwardingRuleset(TrackedResource):
    """Describes a DNS forwarding ruleset.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.dnsresolver.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: Properties of the DNS forwarding ruleset. Required.
    :vartype properties: ~azure.mgmt.dnsresolver.models.DnsForwardingRulesetProperties
    :ivar etag: "If etag is provided in the response body, it may also be provided as a header per
     the normal etag convention.  Entity tags are used for comparing two or more entities from the
     same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match
     (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.").
    :vartype etag: str
    """

    properties: "_models.DnsForwardingRulesetProperties" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Properties of the DNS forwarding ruleset. Required."""
    etag: Optional[str] = rest_field(visibility=["read"])
    """\"If etag is provided in the response body, it may also be provided as a header per the normal
     etag convention.  Entity tags are used for comparing two or more entities from the same
     requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section
     14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.\")."""

    __flattened_items = ["dns_resolver_outbound_endpoints", "provisioning_state", "resource_guid"]

    @overload
    def __init__(
        self,
        *,
        location: str,
        properties: "_models.DnsForwardingRulesetProperties",
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class DnsForwardingRulesetPatch(_Model):
    """Describes a DNS forwarding ruleset PATCH operation.

    :ivar dns_resolver_outbound_endpoints: The reference to the DNS resolver outbound endpoints
     that are used to route DNS queries matching the forwarding rules in the ruleset to the target
     DNS servers.
    :vartype dns_resolver_outbound_endpoints: list[~azure.mgmt.dnsresolver.models.SubResource]
    :ivar tags: Tags for DNS Resolver.
    :vartype tags: dict[str, str]
    """

    dns_resolver_outbound_endpoints: Optional[list["_models.SubResource"]] = rest_field(
        name="dnsResolverOutboundEndpoints", visibility=["read", "create", "update", "delete", "query"]
    )
    """The reference to the DNS resolver outbound endpoints that are used to route DNS queries
     matching the forwarding rules in the ruleset to the target DNS servers."""
    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update"])
    """Tags for DNS Resolver."""

    @overload
    def __init__(
        self,
        *,
        dns_resolver_outbound_endpoints: Optional[list["_models.SubResource"]] = None,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DnsForwardingRulesetProperties(_Model):
    """Represents the properties of a DNS forwarding ruleset.

    :ivar dns_resolver_outbound_endpoints: The reference to the DNS resolver outbound endpoints
     that are used to route DNS queries matching the forwarding rules in the ruleset to the target
     DNS servers. Required.
    :vartype dns_resolver_outbound_endpoints: list[~azure.mgmt.dnsresolver.models.SubResource]
    :ivar provisioning_state: The current provisioning state of the DNS forwarding ruleset. This is
     a read-only property and any attempt to set this value will be ignored. Known values are:
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.dnsresolver.models.ProvisioningState
    :ivar resource_guid: The resourceGuid for the DNS forwarding ruleset.
    :vartype resource_guid: str
    """

    dns_resolver_outbound_endpoints: list["_models.SubResource"] = rest_field(
        name="dnsResolverOutboundEndpoints", visibility=["read", "create", "update", "delete", "query"]
    )
    """The reference to the DNS resolver outbound endpoints that are used to route DNS queries
     matching the forwarding rules in the ruleset to the target DNS servers. Required."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The current provisioning state of the DNS forwarding ruleset. This is a read-only property and
     any attempt to set this value will be ignored. Known values are: \"Creating\", \"Updating\",
     \"Deleting\", \"Succeeded\", \"Failed\", and \"Canceled\"."""
    resource_guid: Optional[str] = rest_field(name="resourceGuid", visibility=["read"])
    """The resourceGuid for the DNS forwarding ruleset."""

    @overload
    def __init__(
        self,
        *,
        dns_resolver_outbound_endpoints: list["_models.SubResource"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DnsResolver(TrackedResource):
    """Describes a DNS resolver.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.dnsresolver.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: Properties of the DNS resolver. Required.
    :vartype properties: ~azure.mgmt.dnsresolver.models.DnsResolverProperties
    :ivar etag: "If etag is provided in the response body, it may also be provided as a header per
     the normal etag convention.  Entity tags are used for comparing two or more entities from the
     same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match
     (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.").
    :vartype etag: str
    """

    properties: "_models.DnsResolverProperties" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Properties of the DNS resolver. Required."""
    etag: Optional[str] = rest_field(visibility=["read"])
    """\"If etag is provided in the response body, it may also be provided as a header per the normal
     etag convention.  Entity tags are used for comparing two or more entities from the same
     requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section
     14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.\")."""

    __flattened_items = ["virtual_network", "dns_resolver_state", "provisioning_state", "resource_guid"]

    @overload
    def __init__(
        self,
        *,
        location: str,
        properties: "_models.DnsResolverProperties",
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class DnsResolverDomainList(TrackedResource):
    """Describes a DNS resolver domain list.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.dnsresolver.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: Properties of the DNS resolver domain list.
    :vartype properties: ~azure.mgmt.dnsresolver.models.DnsResolverDomainListProperties
    :ivar etag: "If etag is provided in the response body, it may also be provided as a header per
     the normal etag convention.  Entity tags are used for comparing two or more entities from the
     same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match
     (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.").
    :vartype etag: str
    """

    properties: Optional["_models.DnsResolverDomainListProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Properties of the DNS resolver domain list."""
    etag: Optional[str] = rest_field(visibility=["read"])
    """\"If etag is provided in the response body, it may also be provided as a header per the normal
     etag convention.  Entity tags are used for comparing two or more entities from the same
     requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section
     14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.\")."""

    __flattened_items = ["domains", "domains_url", "provisioning_state", "resource_guid"]

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
        properties: Optional["_models.DnsResolverDomainListProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class DnsResolverDomainListBulk(_Model):
    """Describes a DNS resolver domain list for bulk UPLOAD or DOWNLOAD operations.

    :ivar properties: Properties of the DNS resolver domain list upload or download request.
     Required.
    :vartype properties: ~azure.mgmt.dnsresolver.models.DnsResolverDomainListBulkProperties
    """

    properties: "_models.DnsResolverDomainListBulkProperties" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Properties of the DNS resolver domain list upload or download request. Required."""

    __flattened_items = ["storage_url", "action"]

    @overload
    def __init__(
        self,
        *,
        properties: "_models.DnsResolverDomainListBulkProperties",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class DnsResolverDomainListBulkProperties(_Model):
    """Describes DNS resolver domain list properties for bulk UPLOAD or DOWNLOAD operations.

    :ivar storage_url: The storage account blob file URL to be used in the bulk upload or download
     request of DNS resolver domain list. Required.
    :vartype storage_url: str
    :ivar action: The action to take in the request, Upload or Download. Required. Known values
     are: "Upload" and "Download".
    :vartype action: str or ~azure.mgmt.dnsresolver.models.Action
    """

    storage_url: str = rest_field(name="storageUrl", visibility=["read", "create", "update", "delete", "query"])
    """The storage account blob file URL to be used in the bulk upload or download request of DNS
     resolver domain list. Required."""
    action: Union[str, "_models.Action"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The action to take in the request, Upload or Download. Required. Known values are: \"Upload\"
     and \"Download\"."""

    @overload
    def __init__(
        self,
        *,
        storage_url: str,
        action: Union[str, "_models.Action"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DnsResolverDomainListPatch(_Model):
    """Describes a DNS resolver domain list for PATCH operation.

    :ivar properties: Updatable properties of the DNS resolver domain list.
    :vartype properties: ~azure.mgmt.dnsresolver.models.DnsResolverDomainListPatchProperties
    :ivar tags: Tags for DNS resolver domain list.
    :vartype tags: dict[str, str]
    """

    properties: Optional["_models.DnsResolverDomainListPatchProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Updatable properties of the DNS resolver domain list."""
    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update"])
    """Tags for DNS resolver domain list."""

    __flattened_items = ["domains"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.DnsResolverDomainListPatchProperties"] = None,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class DnsResolverDomainListPatchProperties(_Model):
    """Represents the updatable properties of a DNS resolver domain list.

    :ivar domains: The domains in the domain list.
    :vartype domains: list[str]
    """

    domains: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The domains in the domain list."""

    @overload
    def __init__(
        self,
        *,
        domains: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DnsResolverDomainListProperties(_Model):
    """Represents the properties of a DNS resolver domain list.

    :ivar domains: The domains in the domain list. Will be null if user is using large domain list.
    :vartype domains: list[str]
    :ivar domains_url: The URL for bulk upload or download for domain lists containing larger set
     of domains. This will be populated if domains is empty or null.
    :vartype domains_url: str
    :ivar provisioning_state: The current provisioning state of the DNS resolver domain list. This
     is a read-only property and any attempt to set this value will be ignored. Known values are:
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.dnsresolver.models.ProvisioningState
    :ivar resource_guid: The resourceGuid property of the DNS resolver domain list resource.
    :vartype resource_guid: str
    """

    domains: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The domains in the domain list. Will be null if user is using large domain list."""
    domains_url: Optional[str] = rest_field(name="domainsUrl", visibility=["read"])
    """The URL for bulk upload or download for domain lists containing larger set of domains. This
     will be populated if domains is empty or null."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The current provisioning state of the DNS resolver domain list. This is a read-only property
     and any attempt to set this value will be ignored. Known values are: \"Creating\",
     \"Updating\", \"Deleting\", \"Succeeded\", \"Failed\", and \"Canceled\"."""
    resource_guid: Optional[str] = rest_field(name="resourceGuid", visibility=["read"])
    """The resourceGuid property of the DNS resolver domain list resource."""

    @overload
    def __init__(
        self,
        *,
        domains: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DnsResolverPatch(_Model):
    """Describes a DNS resolver for PATCH operation.

    :ivar tags: Tags for DNS Resolver.
    :vartype tags: dict[str, str]
    """

    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update"])
    """Tags for DNS Resolver."""

    @overload
    def __init__(
        self,
        *,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DnsResolverPolicy(TrackedResource):
    """Describes a DNS resolver policy.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.dnsresolver.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: Properties of the DNS resolver policy.
    :vartype properties: ~azure.mgmt.dnsresolver.models.DnsResolverPolicyProperties
    :ivar etag: "If etag is provided in the response body, it may also be provided as a header per
     the normal etag convention.  Entity tags are used for comparing two or more entities from the
     same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match
     (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.").
    :vartype etag: str
    """

    properties: Optional["_models.DnsResolverPolicyProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Properties of the DNS resolver policy."""
    etag: Optional[str] = rest_field(visibility=["read"])
    """\"If etag is provided in the response body, it may also be provided as a header per the normal
     etag convention.  Entity tags are used for comparing two or more entities from the same
     requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section
     14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.\")."""

    __flattened_items = ["provisioning_state", "resource_guid"]

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
        properties: Optional["_models.DnsResolverPolicyProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class DnsResolverPolicyPatch(_Model):
    """Describes a DNS resolver policy for PATCH operation.

    :ivar tags: Tags for DNS resolver policy.
    :vartype tags: dict[str, str]
    """

    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update"])
    """Tags for DNS resolver policy."""

    @overload
    def __init__(
        self,
        *,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DnsResolverPolicyProperties(_Model):
    """Represents the properties of a DNS resolver policy.

    :ivar provisioning_state: The current provisioning state of the DNS resolver policy. This is a
     read-only property and any attempt to set this value will be ignored. Known values are:
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.dnsresolver.models.ProvisioningState
    :ivar resource_guid: The resourceGuid property of the DNS resolver policy resource.
    :vartype resource_guid: str
    """

    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The current provisioning state of the DNS resolver policy. This is a read-only property and any
     attempt to set this value will be ignored. Known values are: \"Creating\", \"Updating\",
     \"Deleting\", \"Succeeded\", \"Failed\", and \"Canceled\"."""
    resource_guid: Optional[str] = rest_field(name="resourceGuid", visibility=["read"])
    """The resourceGuid property of the DNS resolver policy resource."""


class DnsResolverPolicyVirtualNetworkLink(TrackedResource):
    """Describes a DNS resolver policy virtual network link.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.dnsresolver.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: Properties of the DNS resolver policy virtual network link. Required.
    :vartype properties:
     ~azure.mgmt.dnsresolver.models.DnsResolverPolicyVirtualNetworkLinkProperties
    :ivar etag: "If etag is provided in the response body, it may also be provided as a header per
     the normal etag convention.  Entity tags are used for comparing two or more entities from the
     same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match
     (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.").
    :vartype etag: str
    """

    properties: "_models.DnsResolverPolicyVirtualNetworkLinkProperties" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Properties of the DNS resolver policy virtual network link. Required."""
    etag: Optional[str] = rest_field(visibility=["read"])
    """\"If etag is provided in the response body, it may also be provided as a header per the normal
     etag convention.  Entity tags are used for comparing two or more entities from the same
     requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section
     14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.\")."""

    __flattened_items = ["virtual_network", "provisioning_state"]

    @overload
    def __init__(
        self,
        *,
        location: str,
        properties: "_models.DnsResolverPolicyVirtualNetworkLinkProperties",
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class DnsResolverPolicyVirtualNetworkLinkPatch(_Model):
    """Describes a DNS resolver policy virtual network link for PATCH operation.

    :ivar tags: Tags for the DNS resolver policy virtual network link.
    :vartype tags: dict[str, str]
    """

    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update"])
    """Tags for the DNS resolver policy virtual network link."""

    @overload
    def __init__(
        self,
        *,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DnsResolverPolicyVirtualNetworkLinkProperties(_Model):  # pylint: disable=name-too-long
    """Represents the properties of a DNS resolver policy virtual network link.

    :ivar virtual_network: The reference to the virtual network. This cannot be changed after
     creation. Required.
    :vartype virtual_network: ~azure.mgmt.dnsresolver.models.SubResource
    :ivar provisioning_state: The current provisioning state of the DNS resolver policy virtual
     network link. This is a read-only property and any attempt to set this value will be ignored.
     Known values are: "Creating", "Updating", "Deleting", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.dnsresolver.models.ProvisioningState
    """

    virtual_network: "_models.SubResource" = rest_field(name="virtualNetwork", visibility=["read", "create"])
    """The reference to the virtual network. This cannot be changed after creation. Required."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The current provisioning state of the DNS resolver policy virtual network link. This is a
     read-only property and any attempt to set this value will be ignored. Known values are:
     \"Creating\", \"Updating\", \"Deleting\", \"Succeeded\", \"Failed\", and \"Canceled\"."""

    @overload
    def __init__(
        self,
        *,
        virtual_network: "_models.SubResource",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DnsResolverProperties(_Model):
    """Represents the properties of a DNS resolver.

    :ivar virtual_network: The reference to the virtual network. This cannot be changed after
     creation. Required.
    :vartype virtual_network: ~azure.mgmt.dnsresolver.models.SubResource
    :ivar dns_resolver_state: The current status of the DNS resolver. This is a read-only property
     and any attempt to set this value will be ignored. Known values are: "Connected" and
     "Disconnected".
    :vartype dns_resolver_state: str or ~azure.mgmt.dnsresolver.models.DnsResolverState
    :ivar provisioning_state: The current provisioning state of the DNS resolver. This is a
     read-only property and any attempt to set this value will be ignored. Known values are:
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.dnsresolver.models.ProvisioningState
    :ivar resource_guid: The resourceGuid property of the DNS resolver resource.
    :vartype resource_guid: str
    """

    virtual_network: "_models.SubResource" = rest_field(name="virtualNetwork", visibility=["read", "create"])
    """The reference to the virtual network. This cannot be changed after creation. Required."""
    dns_resolver_state: Optional[Union[str, "_models.DnsResolverState"]] = rest_field(
        name="dnsResolverState", visibility=["read"]
    )
    """The current status of the DNS resolver. This is a read-only property and any attempt to set
     this value will be ignored. Known values are: \"Connected\" and \"Disconnected\"."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The current provisioning state of the DNS resolver. This is a read-only property and any
     attempt to set this value will be ignored. Known values are: \"Creating\", \"Updating\",
     \"Deleting\", \"Succeeded\", \"Failed\", and \"Canceled\"."""
    resource_guid: Optional[str] = rest_field(name="resourceGuid", visibility=["read"])
    """The resourceGuid property of the DNS resolver resource."""

    @overload
    def __init__(
        self,
        *,
        virtual_network: "_models.SubResource",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DnsSecurityRule(TrackedResource):
    """Describes a DNS security rule.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.dnsresolver.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: Properties of the DNS security rule. Required.
    :vartype properties: ~azure.mgmt.dnsresolver.models.DnsSecurityRuleProperties
    :ivar etag: "If etag is provided in the response body, it may also be provided as a header per
     the normal etag convention.  Entity tags are used for comparing two or more entities from the
     same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match
     (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.").
    :vartype etag: str
    """

    properties: "_models.DnsSecurityRuleProperties" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Properties of the DNS security rule. Required."""
    etag: Optional[str] = rest_field(visibility=["read"])
    """\"If etag is provided in the response body, it may also be provided as a header per the normal
     etag convention.  Entity tags are used for comparing two or more entities from the same
     requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section
     14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.\")."""

    __flattened_items = [
        "priority",
        "action",
        "dns_resolver_domain_lists",
        "managed_domain_lists",
        "dns_security_rule_state",
        "provisioning_state",
    ]

    @overload
    def __init__(
        self,
        *,
        location: str,
        properties: "_models.DnsSecurityRuleProperties",
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class DnsSecurityRuleAction(_Model):
    """The action to take on DNS requests that match the DNS security rule.

    :ivar action_type: The type of action to take. Known values are: "Allow", "Alert", and "Block".
    :vartype action_type: str or ~azure.mgmt.dnsresolver.models.ActionType
    """

    action_type: Optional[Union[str, "_models.ActionType"]] = rest_field(
        name="actionType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of action to take. Known values are: \"Allow\", \"Alert\", and \"Block\"."""

    @overload
    def __init__(
        self,
        *,
        action_type: Optional[Union[str, "_models.ActionType"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DnsSecurityRulePatch(_Model):
    """Describes a DNS security rule for PATCH operation.

    :ivar properties: Updatable properties of the DNS security rule.
    :vartype properties: ~azure.mgmt.dnsresolver.models.DnsSecurityRulePatchProperties
    :ivar tags: Tags for DNS security rule.
    :vartype tags: dict[str, str]
    """

    properties: Optional["_models.DnsSecurityRulePatchProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Updatable properties of the DNS security rule."""
    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update"])
    """Tags for DNS security rule."""

    __flattened_items = [
        "action",
        "dns_resolver_domain_lists",
        "managed_domain_lists",
        "dns_security_rule_state",
        "priority",
    ]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.DnsSecurityRulePatchProperties"] = None,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class DnsSecurityRulePatchProperties(_Model):
    """Represents the updatable properties of a DNS security rule.

    :ivar action: The action to take on DNS requests that match the DNS security rule.
    :vartype action: ~azure.mgmt.dnsresolver.models.DnsSecurityRuleAction
    :ivar dns_resolver_domain_lists: DNS resolver policy domains lists that the DNS security rule
     applies to.
    :vartype dns_resolver_domain_lists: list[~azure.mgmt.dnsresolver.models.SubResource]
    :ivar managed_domain_lists: Managed domain lists that the DNS security rule applies to.
    :vartype managed_domain_lists: list[str or ~azure.mgmt.dnsresolver.models.ManagedDomainList]
    :ivar dns_security_rule_state: The state of DNS security rule. Known values are: "Enabled" and
     "Disabled".
    :vartype dns_security_rule_state: str or ~azure.mgmt.dnsresolver.models.DnsSecurityRuleState
    :ivar priority: The priority of the DNS security rule.
    :vartype priority: int
    """

    action: Optional["_models.DnsSecurityRuleAction"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The action to take on DNS requests that match the DNS security rule."""
    dns_resolver_domain_lists: Optional[list["_models.SubResource"]] = rest_field(
        name="dnsResolverDomainLists", visibility=["read", "create", "update", "delete", "query"]
    )
    """DNS resolver policy domains lists that the DNS security rule applies to."""
    managed_domain_lists: Optional[list[Union[str, "_models.ManagedDomainList"]]] = rest_field(
        name="managedDomainLists", visibility=["read", "create", "update", "delete", "query"]
    )
    """Managed domain lists that the DNS security rule applies to."""
    dns_security_rule_state: Optional[Union[str, "_models.DnsSecurityRuleState"]] = rest_field(
        name="dnsSecurityRuleState", visibility=["read", "create", "update", "delete", "query"]
    )
    """The state of DNS security rule. Known values are: \"Enabled\" and \"Disabled\"."""
    priority: Optional[int] = rest_field(visibility=["read", "create", "update"])
    """The priority of the DNS security rule."""

    @overload
    def __init__(
        self,
        *,
        action: Optional["_models.DnsSecurityRuleAction"] = None,
        dns_resolver_domain_lists: Optional[list["_models.SubResource"]] = None,
        managed_domain_lists: Optional[list[Union[str, "_models.ManagedDomainList"]]] = None,
        dns_security_rule_state: Optional[Union[str, "_models.DnsSecurityRuleState"]] = None,
        priority: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DnsSecurityRuleProperties(_Model):
    """Represents the properties of a DNS security rule.

    :ivar priority: The priority of the DNS security rule. Required.
    :vartype priority: int
    :ivar action: The action to take on DNS requests that match the DNS security rule. Required.
    :vartype action: ~azure.mgmt.dnsresolver.models.DnsSecurityRuleAction
    :ivar dns_resolver_domain_lists: DNS resolver policy domains lists that the DNS security rule
     applies to.
    :vartype dns_resolver_domain_lists: list[~azure.mgmt.dnsresolver.models.SubResource]
    :ivar managed_domain_lists: Managed domain lists that the DNS security rule applies to.
    :vartype managed_domain_lists: list[str or ~azure.mgmt.dnsresolver.models.ManagedDomainList]
    :ivar dns_security_rule_state: The state of DNS security rule. Known values are: "Enabled" and
     "Disabled".
    :vartype dns_security_rule_state: str or ~azure.mgmt.dnsresolver.models.DnsSecurityRuleState
    :ivar provisioning_state: The current provisioning state of the DNS security rule. This is a
     read-only property and any attempt to set this value will be ignored. Known values are:
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.dnsresolver.models.ProvisioningState
    """

    priority: int = rest_field(visibility=["read", "create", "update"])
    """The priority of the DNS security rule. Required."""
    action: "_models.DnsSecurityRuleAction" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The action to take on DNS requests that match the DNS security rule. Required."""
    dns_resolver_domain_lists: Optional[list["_models.SubResource"]] = rest_field(
        name="dnsResolverDomainLists", visibility=["read", "create", "update", "delete", "query"]
    )
    """DNS resolver policy domains lists that the DNS security rule applies to."""
    managed_domain_lists: Optional[list[Union[str, "_models.ManagedDomainList"]]] = rest_field(
        name="managedDomainLists", visibility=["read", "create", "update", "delete", "query"]
    )
    """Managed domain lists that the DNS security rule applies to."""
    dns_security_rule_state: Optional[Union[str, "_models.DnsSecurityRuleState"]] = rest_field(
        name="dnsSecurityRuleState", visibility=["read", "create", "update", "delete", "query"]
    )
    """The state of DNS security rule. Known values are: \"Enabled\" and \"Disabled\"."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The current provisioning state of the DNS security rule. This is a read-only property and any
     attempt to set this value will be ignored. Known values are: \"Creating\", \"Updating\",
     \"Deleting\", \"Succeeded\", \"Failed\", and \"Canceled\"."""

    @overload
    def __init__(
        self,
        *,
        priority: int,
        action: "_models.DnsSecurityRuleAction",
        dns_resolver_domain_lists: Optional[list["_models.SubResource"]] = None,
        managed_domain_lists: Optional[list[Union[str, "_models.ManagedDomainList"]]] = None,
        dns_security_rule_state: Optional[Union[str, "_models.DnsSecurityRuleState"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ErrorAdditionalInfo(_Model):
    """The resource management error additional info.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    type: Optional[str] = rest_field(visibility=["read"])
    """The additional info type."""
    info: Optional[Any] = rest_field(visibility=["read"])
    """The additional info."""


class ErrorDetail(_Model):
    """The error detail.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.dnsresolver.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.dnsresolver.models.ErrorAdditionalInfo]
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    target: Optional[str] = rest_field(visibility=["read"])
    """The error target."""
    details: Optional[list["_models.ErrorDetail"]] = rest_field(visibility=["read"])
    """The error details."""
    additional_info: Optional[list["_models.ErrorAdditionalInfo"]] = rest_field(
        name="additionalInfo", visibility=["read"]
    )
    """The error additional info."""


class ErrorResponse(_Model):
    """Error response.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.dnsresolver.models.ErrorDetail
    """

    error: Optional["_models.ErrorDetail"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error object."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.ErrorDetail"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ProxyResource(Resource):
    """Proxy Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.dnsresolver.models.SystemData
    """


class ForwardingRule(ProxyResource):
    """Describes a forwarding rule within a DNS forwarding ruleset.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.dnsresolver.models.SystemData
    :ivar properties: Properties of the forwarding rule. Required.
    :vartype properties: ~azure.mgmt.dnsresolver.models.ForwardingRuleProperties
    :ivar etag: "If etag is provided in the response body, it may also be provided as a header per
     the normal etag convention.  Entity tags are used for comparing two or more entities from the
     same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match
     (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.").
    :vartype etag: str
    """

    properties: "_models.ForwardingRuleProperties" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Properties of the forwarding rule. Required."""
    etag: Optional[str] = rest_field(visibility=["read"])
    """\"If etag is provided in the response body, it may also be provided as a header per the normal
     etag convention.  Entity tags are used for comparing two or more entities from the same
     requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section
     14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.\")."""

    __flattened_items = ["domain_name", "target_dns_servers", "metadata", "forwarding_rule_state", "provisioning_state"]

    @overload
    def __init__(
        self,
        *,
        properties: "_models.ForwardingRuleProperties",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class ForwardingRulePatch(_Model):
    """Describes a forwarding rule for PATCH operation.

    :ivar properties: Updatable properties of the forwarding rule.
    :vartype properties: ~azure.mgmt.dnsresolver.models.ForwardingRulePatchProperties
    """

    properties: Optional["_models.ForwardingRulePatchProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Updatable properties of the forwarding rule."""

    __flattened_items = ["target_dns_servers", "metadata", "forwarding_rule_state"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.ForwardingRulePatchProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class ForwardingRulePatchProperties(_Model):
    """Represents the updatable properties of a forwarding rule within a DNS forwarding ruleset.

    :ivar target_dns_servers: DNS servers to forward the DNS query to.
    :vartype target_dns_servers: list[~azure.mgmt.dnsresolver.models.TargetDnsServer]
    :ivar metadata: Metadata attached to the forwarding rule.
    :vartype metadata: dict[str, str]
    :ivar forwarding_rule_state: The state of forwarding rule. Known values are: "Enabled" and
     "Disabled".
    :vartype forwarding_rule_state: str or ~azure.mgmt.dnsresolver.models.ForwardingRuleState
    """

    target_dns_servers: Optional[list["_models.TargetDnsServer"]] = rest_field(
        name="targetDnsServers", visibility=["read", "create", "update", "delete", "query"]
    )
    """DNS servers to forward the DNS query to."""
    metadata: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Metadata attached to the forwarding rule."""
    forwarding_rule_state: Optional[Union[str, "_models.ForwardingRuleState"]] = rest_field(
        name="forwardingRuleState", visibility=["read", "create", "update", "delete", "query"]
    )
    """The state of forwarding rule. Known values are: \"Enabled\" and \"Disabled\"."""

    @overload
    def __init__(
        self,
        *,
        target_dns_servers: Optional[list["_models.TargetDnsServer"]] = None,
        metadata: Optional[dict[str, str]] = None,
        forwarding_rule_state: Optional[Union[str, "_models.ForwardingRuleState"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ForwardingRuleProperties(_Model):
    """Represents the properties of a forwarding rule within a DNS forwarding ruleset.

    :ivar domain_name: The domain name for the forwarding rule. Required.
    :vartype domain_name: str
    :ivar target_dns_servers: DNS servers to forward the DNS query to. Required.
    :vartype target_dns_servers: list[~azure.mgmt.dnsresolver.models.TargetDnsServer]
    :ivar metadata: Metadata attached to the forwarding rule.
    :vartype metadata: dict[str, str]
    :ivar forwarding_rule_state: The state of forwarding rule. Known values are: "Enabled" and
     "Disabled".
    :vartype forwarding_rule_state: str or ~azure.mgmt.dnsresolver.models.ForwardingRuleState
    :ivar provisioning_state: The current provisioning state of the forwarding rule. This is a
     read-only property and any attempt to set this value will be ignored. Known values are:
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.dnsresolver.models.ProvisioningState
    """

    domain_name: str = rest_field(name="domainName", visibility=["read", "create", "update", "delete", "query"])
    """The domain name for the forwarding rule. Required."""
    target_dns_servers: list["_models.TargetDnsServer"] = rest_field(
        name="targetDnsServers", visibility=["read", "create", "update", "delete", "query"]
    )
    """DNS servers to forward the DNS query to. Required."""
    metadata: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Metadata attached to the forwarding rule."""
    forwarding_rule_state: Optional[Union[str, "_models.ForwardingRuleState"]] = rest_field(
        name="forwardingRuleState", visibility=["read", "create", "update", "delete", "query"]
    )
    """The state of forwarding rule. Known values are: \"Enabled\" and \"Disabled\"."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The current provisioning state of the forwarding rule. This is a read-only property and any
     attempt to set this value will be ignored. Known values are: \"Creating\", \"Updating\",
     \"Deleting\", \"Succeeded\", \"Failed\", and \"Canceled\"."""

    @overload
    def __init__(
        self,
        *,
        domain_name: str,
        target_dns_servers: list["_models.TargetDnsServer"],
        metadata: Optional[dict[str, str]] = None,
        forwarding_rule_state: Optional[Union[str, "_models.ForwardingRuleState"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class InboundEndpoint(TrackedResource):
    """Describes an inbound endpoint for a DNS resolver.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.dnsresolver.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: Properties of the inbound endpoint. Required.
    :vartype properties: ~azure.mgmt.dnsresolver.models.InboundEndpointProperties
    :ivar etag: "If etag is provided in the response body, it may also be provided as a header per
     the normal etag convention.  Entity tags are used for comparing two or more entities from the
     same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match
     (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.").
    :vartype etag: str
    """

    properties: "_models.InboundEndpointProperties" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Properties of the inbound endpoint. Required."""
    etag: Optional[str] = rest_field(visibility=["read"])
    """\"If etag is provided in the response body, it may also be provided as a header per the normal
     etag convention.  Entity tags are used for comparing two or more entities from the same
     requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section
     14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.\")."""

    __flattened_items = ["ip_configurations", "provisioning_state", "resource_guid"]

    @overload
    def __init__(
        self,
        *,
        location: str,
        properties: "_models.InboundEndpointProperties",
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class InboundEndpointPatch(_Model):
    """Describes an inbound endpoint for a DNS resolver for PATCH operation.

    :ivar tags: Tags for inbound endpoint.
    :vartype tags: dict[str, str]
    """

    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update"])
    """Tags for inbound endpoint."""

    @overload
    def __init__(
        self,
        *,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class InboundEndpointProperties(_Model):
    """Represents the properties of an inbound endpoint for a DNS resolver.

    :ivar ip_configurations: IP configurations for the inbound endpoint. Required.
    :vartype ip_configurations: list[~azure.mgmt.dnsresolver.models.IpConfiguration]
    :ivar provisioning_state: The current provisioning state of the inbound endpoint. This is a
     read-only property and any attempt to set this value will be ignored. Known values are:
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.dnsresolver.models.ProvisioningState
    :ivar resource_guid: The resourceGuid property of the inbound endpoint resource.
    :vartype resource_guid: str
    """

    ip_configurations: list["_models.IpConfiguration"] = rest_field(
        name="ipConfigurations", visibility=["read", "create", "update", "delete", "query"]
    )
    """IP configurations for the inbound endpoint. Required."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The current provisioning state of the inbound endpoint. This is a read-only property and any
     attempt to set this value will be ignored. Known values are: \"Creating\", \"Updating\",
     \"Deleting\", \"Succeeded\", \"Failed\", and \"Canceled\"."""
    resource_guid: Optional[str] = rest_field(name="resourceGuid", visibility=["read"])
    """The resourceGuid property of the inbound endpoint resource."""

    @overload
    def __init__(
        self,
        *,
        ip_configurations: list["_models.IpConfiguration"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class IpConfiguration(_Model):
    """IP configuration.

    :ivar subnet: The reference to the subnet bound to the IP configuration. Required.
    :vartype subnet: ~azure.mgmt.dnsresolver.models.SubResource
    :ivar private_ip_address: Private IP address of the IP configuration.
    :vartype private_ip_address: str
    :ivar private_ip_allocation_method: Private IP address allocation method. Known values are:
     "Static" and "Dynamic".
    :vartype private_ip_allocation_method: str or ~azure.mgmt.dnsresolver.models.IpAllocationMethod
    """

    subnet: "_models.SubResource" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The reference to the subnet bound to the IP configuration. Required."""
    private_ip_address: Optional[str] = rest_field(
        name="privateIpAddress", visibility=["read", "create", "update", "delete", "query"]
    )
    """Private IP address of the IP configuration."""
    private_ip_allocation_method: Optional[Union[str, "_models.IpAllocationMethod"]] = rest_field(
        name="privateIpAllocationMethod", visibility=["read", "create", "update", "delete", "query"]
    )
    """Private IP address allocation method. Known values are: \"Static\" and \"Dynamic\"."""

    @overload
    def __init__(
        self,
        *,
        subnet: "_models.SubResource",
        private_ip_address: Optional[str] = None,
        private_ip_allocation_method: Optional[Union[str, "_models.IpAllocationMethod"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OutboundEndpoint(TrackedResource):
    """Describes an outbound endpoint for a DNS resolver.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.dnsresolver.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: Properties of the outbound endpoint. Required.
    :vartype properties: ~azure.mgmt.dnsresolver.models.OutboundEndpointProperties
    :ivar etag: "If etag is provided in the response body, it may also be provided as a header per
     the normal etag convention.  Entity tags are used for comparing two or more entities from the
     same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match
     (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.").
    :vartype etag: str
    """

    properties: "_models.OutboundEndpointProperties" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Properties of the outbound endpoint. Required."""
    etag: Optional[str] = rest_field(visibility=["read"])
    """\"If etag is provided in the response body, it may also be provided as a header per the normal
     etag convention.  Entity tags are used for comparing two or more entities from the same
     requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section
     14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.\")."""

    __flattened_items = ["subnet", "provisioning_state", "resource_guid"]

    @overload
    def __init__(
        self,
        *,
        location: str,
        properties: "_models.OutboundEndpointProperties",
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class OutboundEndpointPatch(_Model):
    """Describes an outbound endpoint for a DNS resolver for PATCH operation.

    :ivar tags: Tags for outbound endpoint.
    :vartype tags: dict[str, str]
    """

    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update"])
    """Tags for outbound endpoint."""

    @overload
    def __init__(
        self,
        *,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OutboundEndpointProperties(_Model):
    """Represents the properties of an outbound endpoint for a DNS resolver.

    :ivar subnet: The reference to the subnet used for the outbound endpoint. Required.
    :vartype subnet: ~azure.mgmt.dnsresolver.models.SubResource
    :ivar provisioning_state: The current provisioning state of the outbound endpoint. This is a
     read-only property and any attempt to set this value will be ignored. Known values are:
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.dnsresolver.models.ProvisioningState
    :ivar resource_guid: The resourceGuid property of the outbound endpoint resource.
    :vartype resource_guid: str
    """

    subnet: "_models.SubResource" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The reference to the subnet used for the outbound endpoint. Required."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The current provisioning state of the outbound endpoint. This is a read-only property and any
     attempt to set this value will be ignored. Known values are: \"Creating\", \"Updating\",
     \"Deleting\", \"Succeeded\", \"Failed\", and \"Canceled\"."""
    resource_guid: Optional[str] = rest_field(name="resourceGuid", visibility=["read"])
    """The resourceGuid property of the outbound endpoint resource."""

    @overload
    def __init__(
        self,
        *,
        subnet: "_models.SubResource",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SubResource(_Model):
    """Reference to another ARM resource.

    :ivar id: Resource ID. Required.
    :vartype id: str
    """

    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource ID. Required."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SystemData(_Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.dnsresolver.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.dnsresolver.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    created_by: Optional[str] = rest_field(name="createdBy", visibility=["read", "create", "update", "delete", "query"])
    """The identity that created the resource."""
    created_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="createdByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that created the resource. Known values are: \"User\", \"Application\",
     \"ManagedIdentity\", and \"Key\"."""
    created_at: Optional[datetime.datetime] = rest_field(
        name="createdAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource creation (UTC)."""
    last_modified_by: Optional[str] = rest_field(
        name="lastModifiedBy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identity that last modified the resource."""
    last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="lastModifiedByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that last modified the resource. Known values are: \"User\",
     \"Application\", \"ManagedIdentity\", and \"Key\"."""
    last_modified_at: Optional[datetime.datetime] = rest_field(
        name="lastModifiedAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource last modification (UTC)."""

    @overload
    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TargetDnsServer(_Model):
    """Describes a server to forward the DNS queries to.

    :ivar ip_address: DNS server IP address. Required.
    :vartype ip_address: str
    :ivar port: DNS server port.
    :vartype port: int
    """

    ip_address: str = rest_field(name="ipAddress", visibility=["read", "create", "update", "delete", "query"])
    """DNS server IP address. Required."""
    port: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """DNS server port."""

    @overload
    def __init__(
        self,
        *,
        ip_address: str,
        port: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VirtualNetworkDnsForwardingRuleset(_Model):
    """Reference to DNS forwarding ruleset and associated virtual network link.

    :ivar id: DNS Forwarding Ruleset Resource ID.
    :vartype id: str
    :ivar properties: Properties of the virtual network link sub-resource reference.
    :vartype properties: ~azure.mgmt.dnsresolver.models.VirtualNetworkLinkSubResourceProperties
    """

    id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """DNS Forwarding Ruleset Resource ID."""
    properties: Optional["_models.VirtualNetworkLinkSubResourceProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Properties of the virtual network link sub-resource reference."""

    __flattened_items = ["virtual_network_link"]

    @overload
    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        properties: Optional["_models.VirtualNetworkLinkSubResourceProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class VirtualNetworkLink(ProxyResource):
    """Describes a virtual network link.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.dnsresolver.models.SystemData
    :ivar properties: Properties of the virtual network link. Required.
    :vartype properties: ~azure.mgmt.dnsresolver.models.VirtualNetworkLinkProperties
    :ivar etag: "If etag is provided in the response body, it may also be provided as a header per
     the normal etag convention.  Entity tags are used for comparing two or more entities from the
     same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match
     (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.").
    :vartype etag: str
    """

    properties: "_models.VirtualNetworkLinkProperties" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Properties of the virtual network link. Required."""
    etag: Optional[str] = rest_field(visibility=["read"])
    """\"If etag is provided in the response body, it may also be provided as a header per the normal
     etag convention.  Entity tags are used for comparing two or more entities from the same
     requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section
     14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.\")."""

    __flattened_items = ["virtual_network", "metadata", "provisioning_state"]

    @overload
    def __init__(
        self,
        *,
        properties: "_models.VirtualNetworkLinkProperties",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class VirtualNetworkLinkPatch(_Model):
    """Describes a virtual network link for PATCH operation.

    :ivar properties: Updatable properties of the virtual network link.
    :vartype properties: ~azure.mgmt.dnsresolver.models.VirtualNetworkLinkPatchProperties
    """

    properties: Optional["_models.VirtualNetworkLinkPatchProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Updatable properties of the virtual network link."""

    __flattened_items = ["metadata"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.VirtualNetworkLinkPatchProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class VirtualNetworkLinkPatchProperties(_Model):
    """Represents the updatable properties of the virtual network link.

    :ivar metadata: Metadata attached to the virtual network link.
    :vartype metadata: dict[str, str]
    """

    metadata: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Metadata attached to the virtual network link."""

    @overload
    def __init__(
        self,
        *,
        metadata: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VirtualNetworkLinkProperties(_Model):
    """Represents the properties of a virtual network link.

    :ivar virtual_network: The reference to the virtual network. This cannot be changed after
     creation. Required.
    :vartype virtual_network: ~azure.mgmt.dnsresolver.models.SubResource
    :ivar metadata: Metadata attached to the virtual network link.
    :vartype metadata: dict[str, str]
    :ivar provisioning_state: The current provisioning state of the virtual network link. This is a
     read-only property and any attempt to set this value will be ignored. Known values are:
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.dnsresolver.models.ProvisioningState
    """

    virtual_network: "_models.SubResource" = rest_field(
        name="virtualNetwork", visibility=["read", "create", "update", "delete", "query"]
    )
    """The reference to the virtual network. This cannot be changed after creation. Required."""
    metadata: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Metadata attached to the virtual network link."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The current provisioning state of the virtual network link. This is a read-only property and
     any attempt to set this value will be ignored. Known values are: \"Creating\", \"Updating\",
     \"Deleting\", \"Succeeded\", \"Failed\", and \"Canceled\"."""

    @overload
    def __init__(
        self,
        *,
        virtual_network: "_models.SubResource",
        metadata: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VirtualNetworkLinkSubResourceProperties(_Model):
    """The reference to the virtual network link that associates between the DNS forwarding ruleset
    and virtual network.

    :ivar virtual_network_link: The reference to the virtual network link.
    :vartype virtual_network_link: ~azure.mgmt.dnsresolver.models.SubResource
    """

    virtual_network_link: Optional["_models.SubResource"] = rest_field(
        name="virtualNetworkLink", visibility=["read", "create", "update", "delete", "query"]
    )
    """The reference to the virtual network link."""

    @overload
    def __init__(
        self,
        *,
        virtual_network_link: Optional["_models.SubResource"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
